/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.api.data;

import io.annot8.api.data.Content;
import io.annot8.api.filters.Filter;
import io.annot8.api.helpers.WithFilter;
import io.annot8.api.helpers.WithGroups;
import io.annot8.api.helpers.WithId;
import io.annot8.api.helpers.WithMutableProperties;
import java.util.Optional;
import java.util.stream.Stream;

public interface Item
extends WithId,
WithMutableProperties,
WithGroups,
WithFilter<Content<?>> {
    public Optional<String> getParent();

    default public boolean hasParent() {
        return this.getParent().isPresent();
    }

    public Optional<Content<?>> getContent(String var1);

    public Stream<Content<?>> getContents();

    @Override
    default public Stream<Content<?>> filter(Filter<Content<?>> filter) {
        return this.getContents().filter(filter::test);
    }

    default public <T extends Content<?>> Stream<T> getContents(Class<T> clazz) {
        return this.getContents().filter(clazz::isInstance).map(clazz::cast);
    }

    public <C extends Content<D>, D> Content.Builder<C, D> createContent(Class<C> var1);

    public void removeContent(String var1);

    default public void removeContent(Content<?> content) {
        if (content != null) {
            this.removeContent(content.getId());
        }
    }

    public void discard();

    public boolean isDiscarded();

    public Item createChild();
}

