/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.common.data.bounds;

import io.annot8.api.bounds.Bounds;
import io.annot8.api.data.Content;
import io.annot8.common.data.content.Image;
import java.awt.image.BufferedImage;
import java.util.Optional;

public class RectangleBounds
implements Bounds {
    private final int top;
    private final int right;
    private final int bottom;
    private final int left;

    public RectangleBounds(int left, int top, int right, int bottom) {
        this.top = Math.min(top, bottom);
        this.right = Math.max(left, right);
        this.bottom = Math.max(top, bottom);
        this.left = Math.min(left, right);
    }

    @Override
    public <D, C extends Content<D>, R> Optional<R> getData(C content, Class<R> requiredClass) {
        if (content.getDataClass().equals(BufferedImage.class) && requiredClass.isAssignableFrom(BufferedImage.class)) {
            BufferedImage bi = (BufferedImage)content.getData();
            BufferedImage subimage = bi.getSubimage(this.left, this.top, this.getWidth(), this.getHeight());
            return Optional.of(subimage);
        }
        return Optional.empty();
    }

    @Override
    public <D, C extends Content<D>> boolean isValid(C content) {
        return Image.class.isInstance(content);
    }

    public int getBottom() {
        return this.bottom;
    }

    public int getLeft() {
        return this.left;
    }

    public int getRight() {
        return this.right;
    }

    public int getTop() {
        return this.top;
    }

    public int getWidth() {
        return this.right - this.left;
    }

    public int getHeight() {
        return this.bottom - this.top;
    }
}

