/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.common.processing.filters;

import io.annot8.api.annotations.Annotation;
import io.annot8.api.bounds.Bounds;
import io.annot8.api.filters.AndFilter;
import io.annot8.api.filters.Filter;
import io.annot8.api.filters.NotFilter;
import java.util.Optional;

public class AnnotationFilters {
    private AnnotationFilters() {
    }

    public static Filter<Annotation> byType(String type) {
        return new TypeFilter(type);
    }

    public static <B extends Bounds> Filter<Annotation> hasBounds(Class<B> bounds) {
        return new BoundsFilter(bounds);
    }

    public static Filter<Annotation> byProperty(String key) {
        return new HasPropertyFilter(key, null, null);
    }

    public static Filter<Annotation> byProperty(String key, Class<?> clazz) {
        return new HasPropertyFilter(key, clazz, null);
    }

    public static Filter<Annotation> byProperty(String key, Object value) {
        return new HasPropertyFilter(key, null, value);
    }

    public static Filter<Annotation> not(Filter<Annotation> filter) {
        return new NotFilter<Annotation>(filter);
    }

    public static Filter<Annotation> and(Filter<Annotation> ... filters) {
        return new AndFilter<Annotation>(filters);
    }

    public static class HasPropertyFilter
    implements Filter<Annotation> {
        private final String key;
        private final Class<?> valueClass;
        private final Object value;

        public HasPropertyFilter(String key, Class<?> valueClass, Object value) {
            this.key = key;
            this.valueClass = valueClass;
            this.value = value;
        }

        @Override
        public boolean test(Annotation annotation) {
            Optional<Object> o = annotation.getProperties().get(this.key);
            if (o.isEmpty()) {
                return false;
            }
            if (this.value != null) {
                return o.get().equals(this.value);
            }
            if (this.valueClass != null) {
                return this.valueClass.isInstance(o.get());
            }
            return true;
        }
    }

    private static class BoundsFilter
    implements Filter<Annotation> {
        private Class<? extends Bounds> boundsClass;

        public BoundsFilter(Class<? extends Bounds> boundsClass) {
            this.boundsClass = boundsClass;
        }

        @Override
        public boolean test(Annotation annotation) {
            return this.boundsClass.isInstance(annotation.getBounds());
        }
    }

    public static class TypeFilter
    implements Filter<Annotation> {
        private String type;

        public TypeFilter(String type) {
            this.type = type;
        }

        @Override
        public boolean test(Annotation annotation) {
            return annotation.getType().equals(this.type);
        }
    }
}

