/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.base.processors;

import io.annot8.api.annotations.Annotation;
import io.annot8.api.exceptions.BadConfigurationException;
import io.annot8.api.exceptions.ProcessingException;
import io.annot8.api.stores.AnnotationStore;
import io.annot8.common.data.bounds.SpanBounds;
import io.annot8.common.data.content.Text;
import io.annot8.components.base.processors.AbstractTextProcessor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class AbstractRegexProcessor
extends AbstractTextProcessor {
    protected Pattern pattern = null;
    protected int group = 0;
    protected String type = "";

    public AbstractRegexProcessor() {
    }

    public AbstractRegexProcessor(Pattern pattern, int group, String type) {
        this.pattern = pattern;
        this.group = group;
        this.type = type;
    }

    @Override
    protected void process(Text content) {
        if (this.pattern == null) {
            throw new BadConfigurationException("Parameter 'pattern' must not be null");
        }
        AnnotationStore annotationStore = content.getAnnotations();
        Matcher m = this.pattern.matcher((CharSequence)content.getData());
        while (m.find()) {
            if (!this.acceptMatch(m)) continue;
            try {
                Annotation.Builder builder = annotationStore.create();
                this.addProperties(builder, m);
                ((Annotation.Builder)builder.withType(this.type)).withBounds(new SpanBounds(m.start(this.group), m.end(this.group))).save();
            }
            catch (IndexOutOfBoundsException e) {
                throw new ProcessingException("Invalid group", e);
            }
        }
    }

    protected void addProperties(Annotation.Builder builder, Matcher m) {
    }

    protected boolean acceptMatch(Matcher m) {
        return true;
    }
}

