/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.financial.processors;

import io.annot8.api.annotations.Annotation;
import io.annot8.api.capabilities.Capabilities;
import io.annot8.api.components.annotations.ComponentDescription;
import io.annot8.api.components.annotations.ComponentName;
import io.annot8.api.context.Context;
import io.annot8.api.settings.NoSettings;
import io.annot8.api.stores.AnnotationStore;
import io.annot8.common.components.AbstractProcessorDescriptor;
import io.annot8.common.components.capabilities.SimpleCapabilities;
import io.annot8.common.data.bounds.SpanBounds;
import io.annot8.common.data.content.Text;
import io.annot8.components.base.processors.AbstractTextProcessor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.iban4j.Iban;
import org.iban4j.Iban4jException;

@ComponentName(value="IBAN")
@ComponentDescription(value="Extract IBAN (International Bank Account Number) numbers from text")
public class IBAN
extends AbstractProcessorDescriptor<Processor, NoSettings> {
    @Override
    protected Processor createComponent(Context context, NoSettings settings) {
        return new Processor();
    }

    @Override
    public Capabilities capabilities() {
        return new SimpleCapabilities.Builder().withProcessesContent(Text.class).withCreatesAnnotations("entity/financialAccount", SpanBounds.class).build();
    }

    public static class Processor
    extends AbstractTextProcessor {
        private static final Pattern IBAN_PATTERN = Pattern.compile("\\b([A-Z]{2})\\s*([0-9]{2})\\s*(([A-Z0-9]{4}\\s*){2,7}[A-Z0-9]{1,4})\\b", 2);

        @Override
        protected void process(Text content) {
            Matcher m = IBAN_PATTERN.matcher((CharSequence)content.getData());
            AnnotationStore annotationStore = content.getAnnotations();
            while (m.find()) {
                String code = m.group().replaceAll("\\s*", "").toUpperCase();
                try {
                    Iban iban = Iban.valueOf((String)code);
                    ((Annotation.Builder)((Annotation.Builder)((Annotation.Builder)((Annotation.Builder)((Annotation.Builder)annotationStore.create().withType("entity/financialAccount")).withBounds(new SpanBounds(m.start(), m.end())).withProperty("accountNumber", iban.getAccountNumber())).withProperty("bankCode", iban.getBankCode())).withProperty("branchCode", iban.getBranchCode())).withProperty("country", iban.getCountryCode().getAlpha2())).save();
                }
                catch (Iban4jException iban4jException) {}
            }
        }
    }
}

