/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.financial.processors;

import io.annot8.api.annotations.Annotation;
import io.annot8.api.capabilities.Capabilities;
import io.annot8.api.components.annotations.ComponentDescription;
import io.annot8.api.components.annotations.ComponentName;
import io.annot8.api.context.Context;
import io.annot8.api.settings.NoSettings;
import io.annot8.api.stores.AnnotationStore;
import io.annot8.common.components.AbstractProcessorDescriptor;
import io.annot8.common.components.capabilities.SimpleCapabilities;
import io.annot8.common.data.bounds.SpanBounds;
import io.annot8.common.data.content.Text;
import io.annot8.components.base.processors.AbstractTextProcessor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@ComponentName(value="Sort Code")
@ComponentDescription(value="Extract UK sort codes from text")
public class SortCode
extends AbstractProcessorDescriptor<Processor, NoSettings> {
    @Override
    protected Processor createComponent(Context context, NoSettings settings) {
        return new Processor();
    }

    @Override
    public Capabilities capabilities() {
        return new SimpleCapabilities.Builder().withProcessesContent(Text.class).withCreatesAnnotations("entity/financialAccount", SpanBounds.class).build();
    }

    public static class Processor
    extends AbstractTextProcessor {
        private static final Pattern SORT_CODE_PATTERN = Pattern.compile("\\b([0-9]{2})-([0-9]{2})-([0-9]{2})\\b");

        @Override
        protected void process(Text content) {
            Matcher m = SORT_CODE_PATTERN.matcher((CharSequence)content.getData());
            AnnotationStore annotationStore = content.getAnnotations();
            while (m.find()) {
                ((Annotation.Builder)((Annotation.Builder)annotationStore.create().withType("entity/financialAccount")).withBounds(new SpanBounds(m.start(), m.end())).withProperty("branchCode", m.group().replaceAll("-", ""))).save();
            }
        }
    }
}

