/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.gazetteers.processors.impl;

import io.annot8.api.exceptions.BadConfigurationException;
import io.annot8.components.gazetteers.processors.Gazetteer;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class FileGazetteer
implements Gazetteer {
    private List<Set<String>> terms = new ArrayList<Set<String>>();

    public FileGazetteer(Path path, char separator) {
        try {
            Files.lines(path).filter(l -> !l.isBlank()).forEach(l -> this.terms.add(Set.of(l.split(Pattern.quote(String.valueOf(separator))))));
        }
        catch (IOException e) {
            throw new BadConfigurationException("Could not read file gazetteer", e);
        }
    }

    @Override
    public Collection<String> getValues() {
        return this.terms.stream().flatMap(Collection::stream).collect(Collectors.toSet());
    }

    @Override
    public Collection<String> getAliases(String key) {
        for (Set<String> s : this.terms) {
            if (!s.contains(key)) continue;
            return s;
        }
        return Collections.emptySet();
    }

    @Override
    public Map<String, Object> getAdditionalData(String key) {
        return Collections.emptyMap();
    }
}

