/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.geo.processors;

import com.opencsv.CSVReader;
import com.opencsv.exceptions.CsvValidationException;
import io.annot8.api.annotations.Annotation;
import io.annot8.api.capabilities.Capabilities;
import io.annot8.api.components.annotations.ComponentDescription;
import io.annot8.api.components.annotations.ComponentName;
import io.annot8.api.components.annotations.SettingsClass;
import io.annot8.api.context.Context;
import io.annot8.api.settings.NoSettings;
import io.annot8.common.components.AbstractProcessorDescriptor;
import io.annot8.common.components.capabilities.SimpleCapabilities;
import io.annot8.common.data.bounds.SpanBounds;
import io.annot8.common.data.content.Text;
import io.annot8.components.base.processors.AbstractRegexProcessor;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.gov.dstl.geo.osgb.EastingNorthingConversion;

@ComponentName(value="Postcode")
@ComponentDescription(value="Extract UK postcodes from text")
@SettingsClass(value=NoSettings.class)
public class Postcode
extends AbstractProcessorDescriptor<Processor, NoSettings> {
    @Override
    protected Processor createComponent(Context context, NoSettings settings) {
        return new Processor();
    }

    @Override
    public Capabilities capabilities() {
        return new SimpleCapabilities.Builder().withProcessesContent(Text.class).withCreatesAnnotations("entity/address", SpanBounds.class).build();
    }

    public static class Processor
    extends AbstractRegexProcessor {
        private static final String POSTCODE_REGEX = "\\b(GIR 0AA)|((([A-Z-[QVX]][0-9][0-9]?)|(([A-Z-[QVX]][A-Z-[IJZ]][0-9][0-9]?)|(([A-Z-[QVX]][0-9][A-HJKSTUW])|([A-Z-[IJZ]][0-9][ABEHMNPRVWXY])))) [0-9][A-Z-[CIKMOV]]{2})\\b";
        private Map<String, double[]> postcodeResource = new HashMap<String, double[]>();

        public Processor() {
            super(Pattern.compile(POSTCODE_REGEX), 0, "entity/address");
            this.initialisePostcodes();
        }

        @Override
        public void addProperties(Annotation.Builder builder, Matcher m) {
            String cleanPostcode = m.group().replaceAll("\\h+", "");
            if (this.postcodeResource.containsKey(cleanPostcode)) {
                double[] lonlat = this.postcodeResource.getOrDefault(cleanPostcode, null);
                if (lonlat != null && lonlat.length >= 2) {
                    builder.withProperty("latitude", lonlat[0]);
                    builder.withProperty("longitude", lonlat[1]);
                }
                builder.withProperty("postcode", cleanPostcode);
            }
        }

        private void initialisePostcodes() {
            InputStream resourceAsStream = Processor.class.getResourceAsStream("ukpostcodes.csv");
            try (CSVReader reader = new CSVReader((Reader)new InputStreamReader(resourceAsStream));){
                String[] line;
                while ((line = reader.readNext()) != null) {
                    if (line.length < 3) {
                        this.log().warn("Corrupt line found in ukpostcodes.csv - line will be skipped");
                        continue;
                    }
                    double[] lonlat = this.parseEastingNorthingToLatLon(line[1], line[2]);
                    this.postcodeResource.put(line[0].toUpperCase(), lonlat);
                }
                this.log().debug(this.postcodeResource.size() + " postcodes loaded from CSV");
            }
            catch (CsvValidationException | IOException e) {
                this.log().warn("Unable to load postcode data - geospatial data will not be available", e);
            }
        }

        private double[] parseEastingNorthingToLatLon(String easting, String northing) {
            return EastingNorthingConversion.toLatLon((double[])new double[]{Double.parseDouble(easting), Double.parseDouble(northing)}, (double)6377563.396, (double)6356256.909, (double)-100000.0, (double)400000.0, (double)0.9996012717, (double)49.0, (double)-2.0);
        }
    }
}

