/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nca.annot8.components.opennlp.processors;

import io.annot8.api.capabilities.Capabilities;
import io.annot8.api.components.annotations.ComponentDescription;
import io.annot8.api.components.annotations.ComponentName;
import io.annot8.api.components.annotations.SettingsClass;
import io.annot8.api.context.Context;
import io.annot8.api.exceptions.BadConfigurationException;
import io.annot8.api.settings.Description;
import io.annot8.common.components.AbstractProcessorDescriptor;
import io.annot8.common.components.capabilities.SimpleCapabilities;
import io.annot8.common.data.bounds.SpanBounds;
import io.annot8.common.data.content.Text;
import io.annot8.components.base.processors.AbstractTextProcessor;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import uk.gov.nca.annot8.components.opennlp.service.OpenNlpService;

@ComponentName(value="OpenNLP Named Entity Recognition")
@ComponentDescription(value="Use OpenNLP Named Entity Recognition (NER) models to extract named entities as annotations")
@SettingsClass(value=Settings.class)
public class NER
extends AbstractProcessorDescriptor<Processor, Settings> {
    private OpenNlpService openNlpService;

    @Override
    protected Processor createComponent(Context context, Settings settings) {
        Processor p = new Processor(settings);
        p.setOpenNlpService(this.openNlpService);
        return p;
    }

    @Override
    public Capabilities capabilities() {
        return new SimpleCapabilities.Builder().withProcessesContent(Text.class).withCreatesAnnotations("NER", SpanBounds.class).build();
    }

    public void setOpenNlpService(OpenNlpService openNlpService) {
        this.openNlpService = openNlpService;
    }

    public static class Processor
    extends AbstractTextProcessor {
        private String nerType;
        private String type;
        private OpenNlpService openNlpService;

        public Processor(Settings settings) {
            this.nerType = settings.getNerType();
            this.type = settings.getType() != null ? settings.getType() : "entity/" + this.nerType.toLowerCase();
        }

        public void setOpenNlpService(OpenNlpService service) {
            this.openNlpService = service;
        }

        @Override
        protected void process(Text content) {
            this.openNlpService.findEntities(content, this.nerType, this.type);
        }
    }

    public static class Settings
    implements io.annot8.api.settings.Settings {
        private String type;
        private String nerType;
        private static final Set<String> nerTypes = new HashSet<String>(Arrays.asList("Organization", "Location", "Person"));
        private static final Settings organizationInstance = new Settings("Organization", "entity/organization");
        private static final Settings locationInstance = new Settings("Location", "entity/location");
        private static final Settings personInstance = new Settings("Person", "entity/person");

        public Settings() {
            this.nerType = null;
            this.type = null;
        }

        public Settings(String nerType, String type) {
            this.nerType = nerType;
            this.type = type != null ? type : "entity/" + this.nerType.toLowerCase();
        }

        @Override
        public boolean validate() {
            return this.nerType != null && nerTypes.contains(this.nerType);
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        @Description(value="Named entity type e.g. Organization")
        public String getNerType() {
            return this.nerType;
        }

        public void setNerType(String nerType) {
            if (!nerType.contains(nerType)) {
                throw new BadConfigurationException("NER processor type field must be one of:" + Arrays.toString(nerTypes.toArray()));
            }
            this.nerType = nerType;
        }

        public static Settings getOrganizationInstance() {
            return organizationInstance;
        }

        public static Settings getLocationInstance() {
            return locationInstance;
        }

        public static Settings getPersonInstance() {
            return personInstance;
        }
    }
}

