/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nca.elasticsearch.extract;

import io.annot8.api.data.Content;
import io.annot8.api.data.Item;
import io.annot8.common.data.bounds.SpanBounds;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.ingest.IngestDocument;
import uk.gov.nca.elasticsearch.extract.Instance;
import uk.gov.nca.elasticsearch.extract.OpenNlpInstance;
import uk.gov.nca.elasticsearch.extract.TaxonomyInstance;

public class Instances {
    private String startOffsetField;
    private String endOffsetField;
    private Set<String> theseFields;
    private Item item;
    private IngestDocument ingestDocument;
    private List<Instance> instances;
    private Map<String, List<Instance>> idspanInstances;

    public Instances(String startOffsetField, String endOffsetField, Set<String> theseFields, Item item, IngestDocument ingestDocument) {
        this.startOffsetField = startOffsetField;
        this.endOffsetField = endOffsetField;
        this.theseFields = Instances.getFilteredFields(theseFields, ingestDocument);
        this.item = item;
        this.ingestDocument = ingestDocument;
        this.instances = new ArrayList<Instance>();
        this.idspanInstances = new HashMap<String, List<Instance>>();
        this.buildInstances();
    }

    private static Set<String> getFilteredFields(Set<String> theseFields, IngestDocument ingestDocument) {
        return theseFields.stream().filter(field -> ingestDocument.hasField(field) && ingestDocument.getFieldValue(field, String.class) != null).collect(Collectors.toSet());
    }

    private void addInstance(Instance i) {
        this.instances.add(i);
        String idSpan = i.getId() + "-" + i.getStartOffset() + "-" + i.getEndOffset();
        List theseIdspanInstances = this.idspanInstances.getOrDefault(idSpan, new ArrayList());
        theseIdspanInstances.add(i);
        this.idspanInstances.put(idSpan, theseIdspanInstances);
    }

    private void buildInstances() {
        this.theseFields.forEach(field -> {
            Content c = this.item.getContent((String)field).orElse(null);
            c.getAnnotations().getAll().forEach(a -> {
                SpanBounds b = (SpanBounds)a.getBounds();
                String t = (String)b.getData(c).get();
                int begin = b.getBegin();
                int end = b.getEnd();
                String ty = a.getType();
                if (a.getProperties() != null && a.getProperties().has("ids", List.class)) {
                    List nodes = a.getProperties().get("nodes", List.class).get();
                    nodes.forEach(node -> {
                        TaxonomyInstance taxInstance = new TaxonomyInstance(this.startOffsetField, this.endOffsetField, new Integer(begin), new Integer(end), ty, t, (String)field, (String)node.get("id"), (List)node.get("synonyms"), (String)node.get("preferredTerm"), (List)node.get("id_paths"), (List)node.get("pt_paths"), (List)node.get("ancestors"), (List<String>)new ArrayList<String>((Set)node.get("parents")));
                        this.addInstance(taxInstance);
                    });
                } else if (a.getProperties() != null && a.getProperties().has("nerType", String.class)) {
                    OpenNlpInstance instance = new OpenNlpInstance(this.startOffsetField, this.endOffsetField, new Integer(begin), new Integer(end), ty, t, (String)field, ty + ":" + t.toLowerCase(), (Double)a.getProperties().get("probability").orElse(Float.valueOf(0.0f)), a.getProperties().getOrDefault("nerType", "None"));
                    this.addInstance(instance);
                } else {
                    Instance instance = new Instance(this.startOffsetField, this.endOffsetField, new Integer(begin), new Integer(end), ty, t, (String)field, ty + ":" + t.toLowerCase());
                    this.addInstance(instance);
                }
            });
        });
    }

    private List<Map<String, Object>> getCollapsedInstanceObjects() {
        ArrayList<Map<String, Object>> collapsedInstanceObjects = new ArrayList<Map<String, Object>>();
        this.idspanInstances.forEach((idspan, theseInstances) -> {
            if (theseInstances.get(0) instanceof TaxonomyInstance) {
                ArrayList nodes = new ArrayList();
                theseInstances.forEach(i -> nodes.add(((TaxonomyInstance)i).getNodeObject()));
                Map<String, Object> iObj = ((Instance)theseInstances.get(0)).getObject();
                iObj.remove("id");
                iObj.put("nodes", nodes);
                collapsedInstanceObjects.add(iObj);
            } else {
                theseInstances.forEach(i -> collapsedInstanceObjects.add(i.getObject()));
            }
        });
        return collapsedInstanceObjects;
    }

    public Map<String, Object> getExtracted(boolean matches, boolean ids, boolean taxonomyAnnotated, boolean instancesCategorized, boolean instancesCategorizedByField, boolean collapseTaxonomyInstances) {
        HashMap<String, Object> extracted = new HashMap<String, Object>();
        List<Map<String, Object>> theseInstanceObjects = collapseTaxonomyInstances ? this.getCollapsedInstanceObjects() : this.instances.stream().map(instance -> instance.getObject()).collect(Collectors.toList());
        if (!instancesCategorized && !instancesCategorizedByField) {
            extracted.put("instances", theseInstanceObjects);
        } else if (instancesCategorized && !instancesCategorizedByField) {
            extracted.put("instances", theseInstanceObjects.stream().collect(Collectors.groupingBy(i -> (String)i.get("type"))));
        } else if (!instancesCategorized && instancesCategorizedByField) {
            extracted.put("instances", theseInstanceObjects.stream().collect(Collectors.groupingBy(i -> (String)i.get("fromfield"))));
        } else if (instancesCategorized && instancesCategorizedByField) {
            extracted.put("instances", theseInstanceObjects.stream().collect(Collectors.groupingBy(i -> (String)i.get("fromfield"), Collectors.groupingBy(i -> (String)i.get("type")))));
        }
        if (collapseTaxonomyInstances) {
            this.addTaxonomyAnnotated(extracted);
        }
        if (matches) {
            this.addMatches(extracted);
        }
        if (matches) {
            this.addIds(extracted);
        }
        if (taxonomyAnnotated) {
            this.addTaxonomyAnnotated(extracted);
        }
        return extracted;
    }

    private void addValues(Map<String, Object> extracted, boolean matches) {
        HashMap values = new HashMap();
        this.instances.forEach(instance -> {
            Set nl = values.getOrDefault(instance.getType(), new HashSet());
            nl.add(matches ? instance.getMatch() : instance.getId());
            values.put(instance.getType(), nl);
        });
        extracted.put(matches ? "matches" : "ids", values);
    }

    private void addMatches(Map<String, Object> extracted) {
        this.addValues(extracted, true);
    }

    private void addIds(Map<String, Object> extracted) {
        this.addValues(extracted, false);
    }

    private void addTaxonomyAnnotated(Map<String, Object> extracted) {
        HashMap annotated = new HashMap();
        this.theseFields.forEach(field -> {
            String annotatedText = Instances.getAnnotatedText((String)this.ingestDocument.getFieldValue(field, String.class), field, this.instances, this.startOffsetField, this.endOffsetField);
            annotated.put(field, annotatedText);
        });
        extracted.put("taxonomy_annotated", annotated);
    }

    public static String getAnnotatedText(String text, String field, List<Instance> allInstances, String startOffsetField, String endOffsetField) {
        List taxInstances = allInstances.stream().filter(instance -> instance instanceof TaxonomyInstance).filter(instance -> instance.getFromfield().equals(field)).collect(Collectors.toList());
        Collections.sort(taxInstances, new Comparator<Instance>(){

            @Override
            public int compare(Instance o1, Instance o2) {
                return o2.getStartOffset() < o1.getStartOffset() ? 1 : -1;
            }
        });
        StringBuilder sb = new StringBuilder("");
        int lastInstanceEnd = 0;
        for (int i = 0; i < taxInstances.size(); ++i) {
            Instance instance2 = (Instance)taxInstances.get(i);
            if (instance2.getStartOffset() < lastInstanceEnd) continue;
            sb.append(text.substring(lastInstanceEnd, instance2.getStartOffset()));
            sb.append("[");
            sb.append(instance2.getMatch());
            sb.append("]");
            sb.append("(");
            ArrayList<String> textAnnotations = new ArrayList<String>();
            textAnnotations.add(instance2.getId());
            List<String> ancestors = ((TaxonomyInstance)instance2).getAncestors();
            for (int a = 0; a < ancestors.size(); ++a) {
                textAnnotations.add(ancestors.get(a));
            }
            sb.append(String.join((CharSequence)"&", textAnnotations));
            sb.append(")");
            lastInstanceEnd = instance2.getEndOffset();
        }
        sb.append(text.substring(lastInstanceEnd));
        return sb.toString();
    }
}

