/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nca.elasticsearch.extract;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import uk.gov.nca.elasticsearch.extract.Instance;

public class TaxonomyInstance
extends Instance {
    private List<String> synonyms;
    private String preferredTerm;
    private List<String> idPaths;
    private List<String> ptPaths;
    private List<String> ancestors;
    private List<String> parents;

    public TaxonomyInstance(String startOffsetField, String endOffsetField, Integer startOffset, Integer endOffset, String type, String match, String fromfield, String id, List<String> synonyms, String preferredTerm, List<String> idPaths, List<String> ptPaths, List<String> ancestors, List<String> parents) {
        super(startOffsetField, endOffsetField, startOffset, endOffset, type, match, fromfield, id);
        this.synonyms = synonyms;
        this.preferredTerm = preferredTerm;
        this.idPaths = idPaths;
        this.ptPaths = ptPaths;
        this.ancestors = ancestors == null ? new ArrayList() : ancestors;
        this.parents = parents;
    }

    @Override
    public Map<String, Object> getObject() {
        Map<String, Object> o = super.getObject();
        o.put("synonyms", this.synonyms);
        o.put("preferredTerm", this.preferredTerm);
        o.put("id_paths", this.idPaths);
        o.put("pt_paths", this.ptPaths);
        o.put("ancestors", this.ancestors);
        o.put("parents", this.parents);
        return o;
    }

    public Map<String, Object> getNodeObject() {
        HashMap<String, Object> no = new HashMap<String, Object>();
        no.put("id", super.getId());
        no.put("synonyms", this.synonyms);
        no.put("preferredTerm", this.preferredTerm);
        no.put("id_paths", this.idPaths);
        no.put("pt_paths", this.ptPaths);
        no.put("ancestors", this.ancestors);
        no.put("parents", this.parents);
        return no;
    }

    public List<String> getSynonyms() {
        return this.synonyms;
    }

    public void setSynonyms(List<String> synonyms) {
        this.synonyms = synonyms;
    }

    public String getPreferredTerm() {
        return this.preferredTerm;
    }

    public void setPreferredTerm(String preferredTerm) {
        this.preferredTerm = preferredTerm;
    }

    public List<String> getIdPaths() {
        return this.idPaths;
    }

    public void setIdPaths(List<String> idPaths) {
        this.idPaths = idPaths;
    }

    public List<String> getPtPaths() {
        return this.ptPaths;
    }

    public void setPtPaths(List<String> ptPaths) {
        this.ptPaths = ptPaths;
    }

    public List<String> getAncestors() {
        return this.ancestors;
    }

    public void setAncestors(List<String> ancestors) {
        this.ancestors = ancestors;
    }

    public List<String> getParents() {
        return this.parents;
    }

    public void setParents(List<String> parents) {
        this.parents = parents;
    }
}

