/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.api.properties;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface Properties {
    public static boolean equals(Properties a, Properties b) {
        return a.getAll().equals(b.getAll());
    }

    public static int hashCode(Properties properties) {
        return properties.getAll().hashCode();
    }

    default public boolean has(String key) {
        return this.getAll().containsKey(key);
    }

    default public boolean has(String key, Class<?> clazz) {
        return this.getAll(clazz).containsKey(key);
    }

    default public Optional<Object> get(String key) {
        return Optional.ofNullable(this.getAll().get(key));
    }

    default public <T> Optional<T> get(String key, Class<T> clazz) {
        return Optional.ofNullable(this.getAll(clazz).get(key));
    }

    default public Object getObjectOrDefault(String key, Object defaultValue) {
        return this.get(key).orElse(defaultValue);
    }

    default public <T> T getOrDefault(String key, T defaultValue) {
        Object o;
        Class<?> clazz = defaultValue.getClass();
        if (clazz.isInstance(o = this.getObjectOrDefault(key, defaultValue.getClass()))) {
            return (T)clazz.cast(o);
        }
        return defaultValue;
    }

    default public Stream<String> keys() {
        return this.getAll().keySet().stream();
    }

    default public <T> Stream<String> listKeys(Class<T> clazz) {
        return this.getAll(clazz).keySet().stream();
    }

    public Map<String, Object> getAll();

    default public <T> Map<String, T> getAll(Class<T> clazz) {
        return this.getAll().entrySet().stream().filter(e -> clazz.isInstance(e.getValue())).collect(Collectors.toMap(Map.Entry::getKey, e -> clazz.cast(e.getValue())));
    }
}

