/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.common.components.capabilities;

import io.annot8.api.bounds.Bounds;
import io.annot8.api.capabilities.Capabilities;
import io.annot8.api.capabilities.Capability;
import io.annot8.api.data.Content;
import io.annot8.common.components.capabilities.SimpleAnnotationCapability;
import io.annot8.common.components.capabilities.SimpleContentCapability;
import io.annot8.common.components.capabilities.SimpleGroupCapability;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import javax.json.bind.annotation.JsonbCreator;
import javax.json.bind.annotation.JsonbProperty;

public class SimpleCapabilities
implements Capabilities {
    private final Collection<Capability> creates;
    private final Collection<Capability> processes;
    private final Collection<Capability> deletes;

    @JsonbCreator
    public SimpleCapabilities(@JsonbProperty(value="creates") Collection<Capability> creates, @JsonbProperty(value="processes") Collection<Capability> processes, @JsonbProperty(value="deletes") Collection<Capability> deletes) {
        this.creates = creates;
        this.processes = processes;
        this.deletes = deletes;
    }

    @Override
    public Stream<Capability> creates() {
        return this.creates.stream();
    }

    @Override
    public Stream<Capability> processes() {
        return this.processes.stream();
    }

    @Override
    public Stream<Capability> deletes() {
        return this.deletes.stream();
    }

    public static class Builder {
        private List<Capability> creates = new ArrayList<Capability>();
        private List<Capability> processes = new ArrayList<Capability>();
        private List<Capability> deletes = new ArrayList<Capability>();

        public Builder from(Capabilities capabilities) {
            capabilities.creates().forEach(this.creates::add);
            capabilities.processes().forEach(this.processes::add);
            capabilities.deletes().forEach(this.deletes::add);
            return this;
        }

        public Builder withCreates(Capability capability) {
            this.creates.add(capability);
            return this;
        }

        public Builder withoutCreates(Capability capability) {
            this.creates.remove(capability);
            return this;
        }

        public Builder withCreatesAnnotations(String type, Class<? extends Bounds> bounds) {
            return this.withCreates(new SimpleAnnotationCapability(type, bounds));
        }

        public Builder withoutCreatesAnnotations(String type, Class<? extends Bounds> bounds) {
            return this.withoutCreates(new SimpleAnnotationCapability(type, bounds));
        }

        public Builder withCreatesContent(Class<? extends Content> type) {
            return this.withCreates(new SimpleContentCapability(type));
        }

        public Builder withoutCreatesContent(Class<? extends Content> type) {
            return this.withoutCreates(new SimpleContentCapability(type));
        }

        public Builder withCreatesGroups(String type) {
            return this.withCreates(new SimpleGroupCapability(type));
        }

        public Builder withoutCreatesGroups(String type) {
            return this.withoutCreates(new SimpleGroupCapability(type));
        }

        public Builder withProcesses(Capability capability) {
            this.processes.add(capability);
            return this;
        }

        public Builder withoutProcesses(Capability capability) {
            this.processes.remove(capability);
            return this;
        }

        public Builder withProcessesAnnotations(String type, Class<? extends Bounds> bounds) {
            return this.withProcesses(new SimpleAnnotationCapability(type, bounds));
        }

        public Builder withoutProcessesAnnotations(String type, Class<? extends Bounds> bounds) {
            return this.withoutProcesses(new SimpleAnnotationCapability(type, bounds));
        }

        public Builder withProcessesContent(Class<? extends Content> type) {
            return this.withProcesses(new SimpleContentCapability(type));
        }

        public Builder withoutProcessesContent(Class<? extends Content> type) {
            return this.withoutProcesses(new SimpleContentCapability(type));
        }

        public Builder withProcessesGroups(String type) {
            return this.withProcesses(new SimpleGroupCapability(type));
        }

        public Builder withoutProcessesGroups(String type) {
            return this.withoutProcesses(new SimpleGroupCapability(type));
        }

        public Builder withDeletes(Capability capability) {
            this.deletes.add(capability);
            return this;
        }

        public Builder withoutDeletes(Capability capability) {
            this.deletes.remove(capability);
            return this;
        }

        public Builder withDeletesAnnotations(String type, Class<? extends Bounds> bounds) {
            return this.withDeletes(new SimpleAnnotationCapability(type, bounds));
        }

        public Builder withoutDeletesAnnotations(String type, Class<? extends Bounds> bounds) {
            return this.withoutDeletes(new SimpleAnnotationCapability(type, bounds));
        }

        public Builder withDeletesContent(Class<? extends Content> type) {
            return this.withDeletes(new SimpleContentCapability(type));
        }

        public Builder withoutDeletesContent(Class<? extends Content> type) {
            return this.withoutDeletes(new SimpleContentCapability(type));
        }

        public Builder withDeletesGroups(String type) {
            return this.withDeletes(new SimpleGroupCapability(type));
        }

        public Builder withoutDeletesGroups(String type) {
            return this.withoutDeletes(new SimpleGroupCapability(type));
        }

        public SimpleCapabilities build() {
            return new SimpleCapabilities(this.creates, this.processes, this.deletes);
        }
    }
}

