/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.common.data.bounds;

import io.annot8.api.data.Content;
import io.annot8.api.exceptions.Annot8RuntimeException;
import io.annot8.common.data.bounds.AbstractCellBounds;
import io.annot8.common.data.content.Row;
import io.annot8.common.data.content.Table;
import io.annot8.common.data.content.TableContent;
import java.util.Optional;
import javax.json.bind.annotation.JsonbCreator;
import javax.json.bind.annotation.JsonbProperty;

public class CellBounds
extends AbstractCellBounds {
    private final int row;
    private final int column;

    @JsonbCreator
    public CellBounds(@JsonbProperty(value="row") int row, @JsonbProperty(value="column") int column) {
        this.row = row;
        this.column = column;
    }

    @Override
    public <D, C extends Content<D>, R> Optional<R> getData(C content, Class<R> requiredClass) {
        if (this.isValid(content)) {
            Table table = (Table)content.getData();
            Optional<Row> optional = table.getRow(this.row);
            if (optional.isEmpty()) {
                throw new Annot8RuntimeException("Failed to find row");
            }
            Optional<Object> value = optional.get().getValueAt(this.column);
            return value.map(requiredClass::cast);
        }
        return Optional.empty();
    }

    @Override
    public <D, C extends Content<D>> boolean isValid(C content) {
        return super.isValid(content) && this.isCellReferenceValid((TableContent)content, this.row, this.column);
    }

    public int getRow() {
        return this.row;
    }

    public int getColumn() {
        return this.column;
    }
}

