/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.common.data.content;

import io.annot8.common.utils.java.ConversionUtils;
import java.util.List;
import java.util.Optional;

public interface Row {
    public List<String> getColumnNames();

    public int getColumnCount();

    public int getRowIndex();

    public Optional<Object> getValueAt(int var1);

    default public Optional<String> getColumnName(int index) {
        if (this.getColumnNames() == null || this.getColumnNames().isEmpty() || index > this.getColumnCount()) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.getColumnNames().get(index));
    }

    default public Optional<String> getString(int index) {
        return this.getValueAt(index).map(Object::toString);
    }

    default public Optional<Integer> getInt(int index) {
        return ConversionUtils.toInt(this.getValueAt(index));
    }

    default public Optional<Long> getLong(int index) {
        return ConversionUtils.toLong(this.getValueAt(index));
    }

    default public Optional<Double> getDouble(int index) {
        return ConversionUtils.toDouble(this.getValueAt(index));
    }

    default public Optional<Object> getValueAt(String columnName) {
        return this.getIndex(columnName).map(this::getValueAt).filter(Optional::isPresent).map(Optional::get);
    }

    default public Optional<String> getString(String columnName) {
        return this.getValueAt(columnName).map(Object::toString);
    }

    default public Optional<Integer> getInt(String columnName) {
        return ConversionUtils.toInt(this.getValueAt(columnName));
    }

    default public Optional<Long> getLong(String columnName) {
        return ConversionUtils.toLong(this.getValueAt(columnName));
    }

    default public Optional<Double> getDouble(String columnName) {
        return ConversionUtils.toDouble(this.getValueAt(columnName));
    }

    default public Optional<Integer> getIndex(String columnName) {
        if (this.getColumnNames() != null && this.getColumnNames().contains(columnName)) {
            return Optional.of(this.getColumnNames().indexOf(columnName));
        }
        return Optional.empty();
    }

    default public <T> Optional<T> getObject(int index, Class<T> requiredClass) {
        return this.getValueAt(index).map(v -> {
            try {
                return requiredClass.cast(v);
            }
            catch (ClassCastException e) {
                return null;
            }
        });
    }

    default public <T> Optional<T> getObject(String columnName, Class<T> requiredClass) {
        return this.getIndex(columnName).map(i -> this.getObject((int)i, requiredClass)).filter(Optional::isPresent).map(Optional::get);
    }
}

