/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.cyber.processors;

import io.annot8.api.annotations.Annotation;
import io.annot8.api.capabilities.Capabilities;
import io.annot8.api.components.annotations.ComponentDescription;
import io.annot8.api.components.annotations.ComponentName;
import io.annot8.api.components.annotations.ComponentTags;
import io.annot8.api.context.Context;
import io.annot8.api.settings.NoSettings;
import io.annot8.common.components.AbstractProcessorDescriptor;
import io.annot8.common.components.capabilities.SimpleCapabilities;
import io.annot8.common.data.bounds.SpanBounds;
import io.annot8.common.data.content.Text;
import io.annot8.components.base.processors.AbstractRegexProcessor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@ComponentName(value="CVE")
@ComponentDescription(value="Extracts Common Vulnerabilities and Exposure identifiers from text")
@ComponentTags(value={"cyber", "cve", "text"})
public class CVE
extends AbstractProcessorDescriptor<Processor, NoSettings> {
    @Override
    protected Processor createComponent(Context context, NoSettings settings) {
        return new Processor();
    }

    @Override
    public Capabilities capabilities() {
        return new SimpleCapabilities.Builder().withCreatesAnnotations("entity/vulnerability", SpanBounds.class).withProcessesContent(Text.class).build();
    }

    public static class Processor
    extends AbstractRegexProcessor {
        public Processor() {
            super(Pattern.compile("\\bCVE-([0-9]{4})-([0-9]+)\\b", 2), 0, "entity/vulnerability");
        }

        @Override
        protected void addProperties(Annotation.Builder builder, Matcher m) {
            builder.withProperty("year", Integer.parseInt(m.group(1)));
            builder.withProperty("identifier", m.group().toUpperCase());
        }
    }
}

