/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.financial.processors;

import io.annot8.api.annotations.Annotation;
import io.annot8.api.capabilities.Capabilities;
import io.annot8.api.components.annotations.ComponentDescription;
import io.annot8.api.components.annotations.ComponentName;
import io.annot8.api.context.Context;
import io.annot8.api.settings.NoSettings;
import io.annot8.common.components.AbstractProcessorDescriptor;
import io.annot8.common.components.capabilities.SimpleCapabilities;
import io.annot8.common.data.bounds.SpanBounds;
import io.annot8.common.data.content.Text;
import io.annot8.components.base.processors.AbstractRegexProcessor;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@ComponentName(value="Money")
@ComponentDescription(value="Extracts money amounts from text")
public class Money
extends AbstractProcessorDescriptor<Processor, NoSettings> {
    @Override
    protected Processor createComponent(Context context, NoSettings noSettings) {
        return new Processor();
    }

    @Override
    public Capabilities capabilities() {
        return new SimpleCapabilities.Builder().withCreatesAnnotations("entity/money", SpanBounds.class).withProcessesContent(Text.class).build();
    }

    public static class Processor
    extends AbstractRegexProcessor {
        private static final String NUMBER_REGEX = "(?<number>[0-9]{1,3}((?<thousand>[ ,.])?[0-9]{3})?(\\k<thousand>?[0-9]{3})*(?<decimal>[,.])?[0-9]*)";
        private static final String CURRENCY_CODES = "AED|AFN|ALL|AMD|ANG|AOA|ARS|AUD|AWG|AZN|BAM|BBD|BDT|BGN|BHD|BIF|BMD|BND|BOB|BOV|BRL|BSD|BTN|BWP|BYR|BZD|CAD|CDF|CHE|CHF|CHW|CLF|CLP|CNY|COP|COU|CRC|CUC|CUP|CVE|CZK|DJF|DKK|DOP|DZD|EGP|ERN|ETB|EUR|FJD|FKP|GBP|GEL|GHS|GIP|GMD|GNF|GTQ|GYD|HKD|HNL|HRK|HTG|HUF|IDR|ILS|INR|IQD|IRR|ISK|JMD|JOD|JPY|KES|KGS|KHR|KMF|KPW|KRW|KWD|KYD|KZT|LAK|LBP|LKR|LRD|LSL|LYD|MAD|MDL|MGA|MKD|MMK|MNT|MOP|MRO|MUR|MVR|MWK|MXN|MXV|MYR|MZN|NAD|NGN|NIO|NOK|NPR|NZD|OMR|PAB|PEN|PGK|PHP|PKR|PLN|PYG|QAR|RON|RSD|RUB|RWF|SAR|SBD|SCR|SDG|SEK|SGD|SHP|SLL|SOS|SRD|SSP|STD|SYP|SZL|THB|TJS|TMT|TND|TOP|TRY|TTD|TWD|TZS|UAH|UGX|USD|USN|USS|UYI|UYU|UZS|VEF|VND|VUV|WST|XAF|XAG|XAU|XBA|XBB|XBC|XBD|XCD|XDR|XFU|XOF|XPD|XPF|XPT|XSU|XTS|XUA|XXX|YER|ZAR|ZMW";
        private static final String CURRENCY_SYMBOLS = "[\u00a3$\u20ac\u00a5]|Fr";
        private static final String CURRENCY_SYMBOLS_FRACTIONS = "[p\u00a2c]";
        private static final Map<String, String> symbolCountries = Map.ofEntries(Map.entry("\u00a3", "GBP"), Map.entry("$", "USD"), Map.entry("\u20ac", "EUR"), Map.entry("\u00a5", "JPY"), Map.entry("Fr", "CHF"), Map.entry("p", "GBP"), Map.entry("\u00a2", "USD"), Map.entry("c", "EUR"));
        private static final String MULTIPLIERS = "k|thousand|million|m|billion|b|trillion|t";
        private static final Map<String, Double> multiplierValues = Map.ofEntries(Map.entry("k", 1000.0), Map.entry("thousand", 1000.0), Map.entry("million", 1000000.0), Map.entry("m", 1000000.0), Map.entry("billion", 1.0E9), Map.entry("b", 1.0E9), Map.entry("trillion", 1.0E12), Map.entry("t", 1.0E12));
        private static final String WHITESPACE = "\\h*";
        private static final String START = "(?<=^|\\(|\\s)";
        private static final String END = "(?=$|\\)|\\?|!|\\s|[.,](\\s|$))";
        private static final String MONEY_REGEX = "(?<=^|\\(|\\s)((?<code1>AED|AFN|ALL|AMD|ANG|AOA|ARS|AUD|AWG|AZN|BAM|BBD|BDT|BGN|BHD|BIF|BMD|BND|BOB|BOV|BRL|BSD|BTN|BWP|BYR|BZD|CAD|CDF|CHE|CHF|CHW|CLF|CLP|CNY|COP|COU|CRC|CUC|CUP|CVE|CZK|DJF|DKK|DOP|DZD|EGP|ERN|ETB|EUR|FJD|FKP|GBP|GEL|GHS|GIP|GMD|GNF|GTQ|GYD|HKD|HNL|HRK|HTG|HUF|IDR|ILS|INR|IQD|IRR|ISK|JMD|JOD|JPY|KES|KGS|KHR|KMF|KPW|KRW|KWD|KYD|KZT|LAK|LBP|LKR|LRD|LSL|LYD|MAD|MDL|MGA|MKD|MMK|MNT|MOP|MRO|MUR|MVR|MWK|MXN|MXV|MYR|MZN|NAD|NGN|NIO|NOK|NPR|NZD|OMR|PAB|PEN|PGK|PHP|PKR|PLN|PYG|QAR|RON|RSD|RUB|RWF|SAR|SBD|SCR|SDG|SEK|SGD|SHP|SLL|SOS|SRD|SSP|STD|SYP|SZL|THB|TJS|TMT|TND|TOP|TRY|TTD|TWD|TZS|UAH|UGX|USD|USN|USS|UYI|UYU|UZS|VEF|VND|VUV|WST|XAF|XAG|XAU|XBA|XBB|XBC|XBD|XCD|XDR|XFU|XOF|XPD|XPF|XPT|XSU|XTS|XUA|XXX|YER|ZAR|ZMW)|(?<symbol1>[\u00a3$\u20ac\u00a5]|Fr))?(\\h*(?<number>[0-9]{1,3}((?<thousand>[ ,.])?[0-9]{3})?(\\k<thousand>?[0-9]{3})*(?<decimal>[,.])?[0-9]*))(\\h*(?<multiplier1>k|thousand|million|m|billion|b|trillion|t))?(\\h*((?<code2>AED|AFN|ALL|AMD|ANG|AOA|ARS|AUD|AWG|AZN|BAM|BBD|BDT|BGN|BHD|BIF|BMD|BND|BOB|BOV|BRL|BSD|BTN|BWP|BYR|BZD|CAD|CDF|CHE|CHF|CHW|CLF|CLP|CNY|COP|COU|CRC|CUC|CUP|CVE|CZK|DJF|DKK|DOP|DZD|EGP|ERN|ETB|EUR|FJD|FKP|GBP|GEL|GHS|GIP|GMD|GNF|GTQ|GYD|HKD|HNL|HRK|HTG|HUF|IDR|ILS|INR|IQD|IRR|ISK|JMD|JOD|JPY|KES|KGS|KHR|KMF|KPW|KRW|KWD|KYD|KZT|LAK|LBP|LKR|LRD|LSL|LYD|MAD|MDL|MGA|MKD|MMK|MNT|MOP|MRO|MUR|MVR|MWK|MXN|MXV|MYR|MZN|NAD|NGN|NIO|NOK|NPR|NZD|OMR|PAB|PEN|PGK|PHP|PKR|PLN|PYG|QAR|RON|RSD|RUB|RWF|SAR|SBD|SCR|SDG|SEK|SGD|SHP|SLL|SOS|SRD|SSP|STD|SYP|SZL|THB|TJS|TMT|TND|TOP|TRY|TTD|TWD|TZS|UAH|UGX|USD|USN|USS|UYI|UYU|UZS|VEF|VND|VUV|WST|XAF|XAG|XAU|XBA|XBB|XBC|XBD|XCD|XDR|XFU|XOF|XPD|XPF|XPT|XSU|XTS|XUA|XXX|YER|ZAR|ZMW)|(?<symbol2>[\u00a3$\u20ac\u00a5]|Fr)|(?<fraction>[p\u00a2c])))?(\\h*((?<multiplier2>k|thousand|million|m|billion|b|trillion|t)))?(?=$|\\)|\\?|!|\\s|[.,](\\s|$))";

        public Processor() {
            super(Pattern.compile(MONEY_REGEX), 0, "entity/money");
        }

        @Override
        protected void addProperties(Annotation.Builder builder, Matcher m) {
            String currencyCode;
            Double value = this.calculateValue(m);
            if (value != null) {
                builder.withProperty("value", this.calculateValue(m));
            }
            if ((currencyCode = this.getCurrencyCode(m)) != null && !currencyCode.isEmpty()) {
                builder.withProperty("currencyCode", currencyCode);
            }
        }

        private Double calculateValue(Matcher m) {
            double value;
            try {
                value = Double.parseDouble(this.normaliseMatchedNumber(m));
            }
            catch (NumberFormatException nfe) {
                this.log().warn("Unable to parse value", (Throwable)nfe);
                return null;
            }
            value = this.applyMultipliers(m, value);
            value = this.applyFractionModifier(m, value);
            return value;
        }

        private double applyMultipliers(Matcher m, double value) {
            String multiplier = this.getNamedGroup(m, "multiplier");
            if (multiplier == null) {
                return value;
            }
            return value * multiplierValues.getOrDefault(multiplier, 1.0);
        }

        private double applyFractionModifier(Matcher m, double value) {
            if (m.group("fraction") == null) {
                return value;
            }
            if (this.getNamedGroup(m, "symbol") == null) {
                return value / 100.0;
            }
            return value;
        }

        private String getCurrencyCode(Matcher m) {
            String namedCode = this.getNamedGroup(m, "code");
            if (namedCode != null) {
                return namedCode;
            }
            String symbol = this.getSymbol(m);
            if (symbol == null) {
                return "";
            }
            return symbolCountries.getOrDefault(symbol, "");
        }

        private String getSymbol(Matcher m) {
            String symbol = this.getNamedGroup(m, "symbol");
            if (symbol == null) {
                return m.group("fraction");
            }
            return symbol;
        }

        private String getNamedGroup(Matcher m, String groupName) {
            if (m.group(groupName + "1") != null) {
                return m.group(groupName + "1");
            }
            return m.group(groupName + "2");
        }

        private String normaliseMatchedNumber(Matcher m) {
            String number = m.group("number");
            if (m.group("thousand") != null) {
                number = number.replace(m.group("thousand"), "");
            }
            if (m.group("decimal") != null) {
                number = number.replace(m.group("decimal"), ".");
            }
            return number;
        }
    }
}

