/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.gazetteers.processors;

import io.annot8.api.annotations.Annotation;
import io.annot8.api.annotations.Group;
import io.annot8.api.capabilities.Capabilities;
import io.annot8.api.settings.Description;
import io.annot8.common.components.AbstractProcessorDescriptor;
import io.annot8.common.components.capabilities.SimpleCapabilities;
import io.annot8.common.data.bounds.SpanBounds;
import io.annot8.common.data.content.Text;
import io.annot8.components.base.processors.AbstractTextProcessor;
import io.annot8.components.gazetteers.processors.Gazetteer;
import io.annot8.utils.text.PluralUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.ahocorasick.trie.Emit;
import org.ahocorasick.trie.Trie;

public abstract class AhoCorasick<S extends Settings>
extends AbstractProcessorDescriptor<Processor, S> {
    @Override
    public Capabilities capabilities() {
        return new SimpleCapabilities.Builder().withProcessesContent(Text.class).withCreatesAnnotations(((Settings)this.getSettings()).getType(), SpanBounds.class).withCreatesGroups("aliases").build();
    }

    protected static class TransformedString {
        private final String original;
        private final String transformed;
        private final Map<Integer, Integer> map;

        public TransformedString(String originalString, String transformedString, Map<Integer, Integer> mapping) {
            this.original = originalString;
            this.transformed = transformedString;
            this.map = mapping;
        }

        public String getOriginalString() {
            return this.original;
        }

        public String getTransformedString() {
            return this.transformed;
        }

        public Map<Integer, Integer> getMapping() {
            return this.map;
        }
    }

    public static class Settings
    implements io.annot8.api.settings.Settings {
        private boolean caseSensitive = false;
        private boolean exactWhitespace = false;
        private String type = "entity/unknown";
        private String subType = null;
        private boolean additionalData = false;
        private boolean plurals = true;

        @Override
        public boolean validate() {
            return this.type != null && !this.type.isEmpty();
        }

        @Description(value="Should comparisons be done case-sensitively?")
        public boolean isCaseSensitive() {
            return this.caseSensitive;
        }

        public void setCaseSensitive(boolean caseSensitive) {
            this.caseSensitive = caseSensitive;
        }

        @Description(value="Should whitespace in document be preserved?")
        public boolean isExactWhitespace() {
            return this.exactWhitespace;
        }

        public void setExactWhitespace(boolean exactWhitespace) {
            this.exactWhitespace = exactWhitespace;
        }

        @Description(value="The annotation type")
        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        @Description(value="The annotation subtype, or null")
        public String getSubType() {
            return this.subType;
        }

        public void setSubType(String subType) {
            this.subType = subType;
        }

        @Description(value="Should additional data be added to annotations as properties?")
        public boolean isAdditionalData() {
            return this.additionalData;
        }

        public void setAdditionalData(boolean additionalData) {
            this.additionalData = additionalData;
        }

        @Description(value="Should we accept plurals as matches?")
        public boolean isPlurals() {
            return this.plurals;
        }

        public void setPlurals(boolean plurals) {
            this.plurals = plurals;
        }
    }

    public static class Processor
    extends AbstractTextProcessor {
        private final Trie trie;
        private final Gazetteer gazetteer;
        private final Settings settings;

        public Processor(Gazetteer gazetteer, Settings settings) {
            this.gazetteer = gazetteer;
            this.settings = settings;
            this.trie = this.buildTrie(gazetteer, settings);
        }

        protected Trie buildTrie(Gazetteer gazetteer, Settings settings) {
            Trie.TrieBuilder builder = Trie.builder().onlyWholeWords();
            if (!settings.isCaseSensitive()) {
                builder = builder.ignoreCase();
            }
            for (String s : gazetteer.getValues()) {
                builder = builder.addKeyword(s);
                if (!settings.isPlurals()) continue;
                builder = builder.addKeyword(PluralUtils.pluralise(s));
            }
            return builder.build();
        }

        @Override
        protected void process(Text content) {
            TransformedString norm = this.settings.isExactWhitespace() ? Processor.noopString((String)content.getData()) : Processor.normaliseString((String)content.getData());
            Collection<Emit> emits = this.trie.parseText(norm.getTransformedString());
            HashMap<String, List> aliasGroups = new HashMap<String, List>();
            for (Emit emit : emits) {
                Integer start = norm.getMapping().get(emit.getStart());
                Integer end = norm.getMapping().get(emit.getEnd() + 1);
                Annotation.Builder builder = (Annotation.Builder)content.getAnnotations().create().withBounds(new SpanBounds(start, end)).withType(this.settings.getType());
                if (this.settings.getSubType() != null) {
                    builder = (Annotation.Builder)builder.withProperty("subtype", this.settings.getSubType());
                }
                if (this.settings.isAdditionalData()) {
                    for (Map.Entry<String, Object> e : this.gazetteer.getAdditionalData(emit.getKeyword()).entrySet()) {
                        builder = (Annotation.Builder)builder.withProperty(e.getKey(), e.getValue());
                    }
                }
                Annotation a2 = (Annotation)builder.save();
                String key = this.generateKey(this.gazetteer.getAliases(emit.getKeyword()));
                aliasGroups.computeIfAbsent(key, k -> new ArrayList()).add(a2);
            }
            for (List group : aliasGroups.values()) {
                if (group.size() == 1) continue;
                Group.Builder builder = (Group.Builder)content.getItem().getGroups().create().withType("group/aliases");
                group.forEach(a -> builder.withAnnotation("alias", (Annotation)a));
                builder.save();
            }
        }

        private String generateKey(Collection<String> aliases) {
            return aliases.stream().map(String::toLowerCase).sorted().collect(Collectors.joining("|"));
        }

        protected static TransformedString noopString(String s) {
            HashMap<Integer, Integer> indexMap = new HashMap<Integer, Integer>();
            for (int i = 0; i < s.length(); ++i) {
                indexMap.put(i, i);
            }
            return new TransformedString(s, s, indexMap);
        }

        protected static TransformedString normaliseString(String s) {
            String remaining = s;
            StringBuilder builder = new StringBuilder();
            String previousChar = "";
            HashMap<Integer, Integer> indexMap = new HashMap<Integer, Integer>();
            Integer index = 0;
            while (!remaining.isEmpty()) {
                indexMap.put(builder.length(), index);
                Integer n = index;
                Integer n2 = index = Integer.valueOf(index + 1);
                String character = remaining.substring(0, 1);
                remaining = remaining.substring(1);
                if (!character.matches("\\h") || !previousChar.matches("\\h")) {
                    if (character.matches("\\h")) {
                        character = " ";
                    }
                    builder.append(character);
                }
                previousChar = character;
            }
            indexMap.put(builder.length(), index);
            return new TransformedString(s, builder.toString(), indexMap);
        }
    }
}

