/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.implementations.pipeline;

import io.annot8.api.components.ProcessorDescriptor;
import io.annot8.api.components.SourceDescriptor;
import io.annot8.api.exceptions.IncompleteException;
import io.annot8.api.pipelines.NoOpOrderer;
import io.annot8.api.pipelines.PipelineDescriptor;
import io.annot8.api.pipelines.PipelineOrderer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SimplePipelineDescriptor
implements PipelineDescriptor {
    private final String name;
    private final String description;
    private final Collection<SourceDescriptor> sources;
    private final Collection<ProcessorDescriptor> processors;

    private SimplePipelineDescriptor(String name, String description, Collection<SourceDescriptor> sources, Collection<ProcessorDescriptor> processors) {
        this.name = name;
        this.description = description;
        this.sources = sources;
        this.processors = processors;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Collection<SourceDescriptor> getSources() {
        return this.sources;
    }

    @Override
    public Collection<ProcessorDescriptor> getProcessors() {
        return this.processors;
    }

    public static class Builder
    implements PipelineDescriptor.Builder {
        private String name;
        private String description;
        private List<SourceDescriptor> sources = new ArrayList<SourceDescriptor>();
        private List<ProcessorDescriptor> processors = new ArrayList<ProcessorDescriptor>();
        private PipelineOrderer orderer = NoOpOrderer.getInstance();

        @Override
        public Builder from(PipelineDescriptor pipelineDescriptor) {
            this.name = pipelineDescriptor.getName();
            this.description = pipelineDescriptor.getDescription();
            this.sources.addAll(pipelineDescriptor.getSources());
            this.processors.addAll(pipelineDescriptor.getProcessors());
            return this;
        }

        @Override
        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        @Override
        public Builder withDescription(String description) {
            this.description = description;
            return this;
        }

        @Override
        public PipelineDescriptor.Builder withOrderer(PipelineOrderer orderer) {
            this.orderer = orderer;
            return this;
        }

        @Override
        public Builder withSource(SourceDescriptor source) {
            this.sources.add(source);
            return this;
        }

        @Override
        public Builder withProcessor(ProcessorDescriptor processor) {
            this.processors.add(processor);
            return this;
        }

        @Override
        public SimplePipelineDescriptor build() throws IncompleteException {
            if (this.name == null || this.name.isEmpty()) {
                throw new IncompleteException("Pipeline must have a name");
            }
            if (this.sources.isEmpty()) {
                throw new IncompleteException("Pipeline requires at least one source");
            }
            if (this.processors.isEmpty()) {
                throw new IncompleteException("Pipeline requires at least one processor");
            }
            if (this.orderer == null) {
                throw new IncompleteException("Pipeline requires a PipelineOrderer");
            }
            Collection<SourceDescriptor> orderedSources = this.orderer.orderSources(this.sources);
            Collection<ProcessorDescriptor> orderedProcessors = this.orderer.orderProcessors(this.processors);
            return new SimplePipelineDescriptor(this.name, this.description, orderedSources, orderedProcessors);
        }
    }
}

