/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.implementations.reference.data;

import io.annot8.api.data.Content;
import io.annot8.api.data.Item;
import io.annot8.api.data.ItemFactory;
import io.annot8.api.exceptions.IncompleteException;
import io.annot8.api.exceptions.UnsupportedContentException;
import io.annot8.api.properties.MutableProperties;
import io.annot8.api.stores.GroupStore;
import io.annot8.implementations.reference.stores.DefaultGroupStore;
import io.annot8.implementations.support.delegates.DelegateContentBuilder;
import io.annot8.implementations.support.properties.MapMutableProperties;
import io.annot8.implementations.support.registries.ContentBuilderFactoryRegistry;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;

public class DefaultItem
implements Item {
    private final Map<String, Content<?>> contents = new ConcurrentHashMap();
    private final MutableProperties properties = new MapMutableProperties();
    private final ContentBuilderFactoryRegistry contentBuilderFactoryRegistry;
    private final DefaultGroupStore groups;
    private final String id;
    private final String parentId;
    private final ItemFactory itemFactory;
    private boolean discarded = false;

    public DefaultItem(String parentId, ItemFactory itemFactory, ContentBuilderFactoryRegistry contentBuilderFactoryRegistry) {
        this.parentId = parentId;
        this.itemFactory = itemFactory;
        this.id = UUID.randomUUID().toString();
        this.contentBuilderFactoryRegistry = contentBuilderFactoryRegistry;
        this.groups = new DefaultGroupStore(this);
    }

    public DefaultItem(ItemFactory itemFactory, ContentBuilderFactoryRegistry contentBuilderFactoryRegistry) {
        this(null, itemFactory, contentBuilderFactoryRegistry);
    }

    @Override
    public Optional<String> getParent() {
        return Optional.ofNullable(this.parentId);
    }

    @Override
    public Optional<Content<?>> getContent(String id) {
        return Optional.ofNullable(this.contents.get(id));
    }

    @Override
    public Stream<Content<?>> getContents() {
        return this.contents.values().stream();
    }

    @Override
    public <C extends Content<D>, D> Content.Builder<C, D> createContent(Class<C> clazz) {
        Optional factory = this.contentBuilderFactoryRegistry.get(clazz);
        if (factory.isEmpty()) {
            throw new UnsupportedContentException("Unknown content type: " + clazz.getSimpleName());
        }
        return new DelegateContentBuilder<C, D>(factory.get().create(this)){

            @Override
            public C save() throws IncompleteException {
                Object c = super.save();
                return DefaultItem.this.save(c);
            }
        };
    }

    private <D, C extends Content<D>> C save(C c) {
        assert (c != null);
        this.contents.put(c.getId(), c);
        return c;
    }

    @Override
    public void removeContent(String id) {
        this.contents.remove(id);
    }

    @Override
    public GroupStore getGroups() {
        return this.groups;
    }

    @Override
    public MutableProperties getProperties() {
        return this.properties;
    }

    @Override
    public void discard() {
        this.discarded = true;
    }

    @Override
    public boolean isDiscarded() {
        return this.discarded;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Item createChild() {
        return this.itemFactory.create(this);
    }
}

