/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.implementations.reference.references;

import io.annot8.api.annotations.Annotation;
import io.annot8.api.data.Content;
import io.annot8.api.data.Item;
import io.annot8.implementations.support.references.AbstractAnnotationReference;
import java.util.Optional;

public class DefaultAnnotationReference
extends AbstractAnnotationReference {
    private final Item item;
    private final String contentId;
    private final String annotationId;

    public DefaultAnnotationReference(Item item, String contentId, String annotationId) {
        this.item = item;
        this.contentId = contentId;
        this.annotationId = annotationId;
    }

    public static DefaultAnnotationReference to(Item item, Annotation annotation) {
        return new DefaultAnnotationReference(item, annotation.getContentId(), annotation.getId());
    }

    @Override
    public String getAnnotationId() {
        return this.annotationId;
    }

    @Override
    public String getContentId() {
        return this.contentId;
    }

    @Override
    public Optional<Annotation> toAnnotation() {
        return this.item.getContent(this.contentId).map(Content::getAnnotations).flatMap(store -> store.getById(this.annotationId));
    }
}

