/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.implementations.reference.stores;

import io.annot8.api.annotations.Annotation;
import io.annot8.api.data.Content;
import io.annot8.api.stores.AnnotationStore;
import io.annot8.implementations.reference.annotations.DefaultAnnotation;
import io.annot8.implementations.support.delegates.DelegateAnnotationBuilder;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DefaultAnnotationStore
implements AnnotationStore {
    private final Map<String, Annotation> annotations = new ConcurrentHashMap<String, Annotation>();
    private final Content<?> content;

    public DefaultAnnotationStore(Content<?> content) {
        this.content = content;
    }

    @Override
    public Content<?> getContent() {
        return this.content;
    }

    @Override
    public Annotation.Builder getBuilder() {
        return new DelegateAnnotationBuilder(new DefaultAnnotation.Builder(this.content.getId())){

            @Override
            public Annotation save() {
                return DefaultAnnotationStore.this.save(super.save());
            }
        };
    }

    private Annotation save(Annotation annotation) {
        this.annotations.put(annotation.getId(), annotation);
        return annotation;
    }

    @Override
    public void delete(Annotation annotation) {
        this.annotations.remove(annotation.getId(), annotation);
    }

    @Override
    public Stream<Annotation> getAll() {
        return this.annotations.values().stream();
    }

    @Override
    public Optional<Annotation> getById(String s) {
        return Optional.ofNullable(this.annotations.get(s));
    }

    public String toString() {
        return this.getClass().getName() + " [annotations=" + this.annotations.size() + "]";
    }

    public int hashCode() {
        return Objects.hash(this.annotations);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AnnotationStore)) {
            return false;
        }
        AnnotationStore as = (AnnotationStore)obj;
        Set allAnnotations = as.getAll().collect(Collectors.toSet());
        return Objects.equals(new HashSet<Annotation>(this.annotations.values()), allAnnotations);
    }
}

