/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.implementations.reference.stores;

import io.annot8.api.annotations.Group;
import io.annot8.api.data.Item;
import io.annot8.api.stores.GroupStore;
import io.annot8.implementations.reference.annotations.DefaultGroup;
import io.annot8.implementations.support.delegates.DelegateGroupBuilder;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DefaultGroupStore
implements GroupStore {
    private final Item item;
    private final Map<String, Group> groups = new ConcurrentHashMap<String, Group>();

    public DefaultGroupStore(Item item) {
        this.item = item;
    }

    @Override
    public Item getItem() {
        return this.item;
    }

    @Override
    public Group.Builder getBuilder() {
        return new DelegateGroupBuilder(new DefaultGroup.Builder(this.item)){

            @Override
            public Group save() {
                return DefaultGroupStore.this.save(super.save());
            }
        };
    }

    private Group save(Group group) {
        this.groups.put(group.getId(), group);
        return group;
    }

    @Override
    public void delete(Group group) {
        this.groups.remove(group.getId(), group);
    }

    @Override
    public Stream<Group> getAll() {
        return this.groups.values().stream();
    }

    @Override
    public Optional<Group> getById(String s) {
        return Optional.ofNullable(this.groups.get(s));
    }

    public String toString() {
        return this.getClass().getName() + " [groups=" + this.groups.size() + "]";
    }

    public int hashCode() {
        return Objects.hash(this.groups);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GroupStore)) {
            return false;
        }
        GroupStore gs = (GroupStore)obj;
        Set allGroups = gs.getAll().collect(Collectors.toSet());
        return Objects.equals(new HashSet<Group>(this.groups.values()), allGroups);
    }
}

